<?php

namespace App\Http\Middleware;

use App\Providers\RouteServiceProvider;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class RedirectIfAuthenticated
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next, string ...$guards): Response
    {
        $guards = empty($guards) ? [null] : $guards;

        foreach ($guards as $guard) {

            if (Auth::guard($guard)->check()) {
                if ($guard == 'admin') {
                    $admin = Auth::guard('admin')->user();
                    // check if login user has role
                    if (!$admin->hasAnyRole()) {
                        Auth::guard('admin')->logout();

                        return redirect()->route('admin.login')->with([
                            'message' => 'You don\'t have any role',
                            'alert-type' => 'error'
                        ]);
                    }
                    return redirect(RouteServiceProvider::ADMIN);
                } else {
                    $user = Auth::guard('web')->user();

                    return redirect(RouteServiceProvider::USER);
                }
            }
        }

        return $next($request);
    }
}
